IF  EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_PG_CRED_FORN_CREDITO_DEBITO]'))

DROP VIEW [DBO].[V_PG_CRED_FORN_CREDITO_DEBITO]    
GO
/*
SELECT 	
	CD_EMP,
	CD_FORN, 
	SUM(VLR_CRED) AS VLR_CRED, 
	SUM(VLR_DEB) AS VLR_DEB,
	SUM(VLR_CRED)- SUM(VLR_DEB) AS SLD_FORNECEDOR
FROM
	V_PG_CRED_FORN_CREDITO_DEBITO
WHERE
	DT_CAD < '2014-01-10'
	AND CD_FORN = 112
GROUP BY
	CD_EMP,
	CD_FORN
*/	

CREATE VIEW V_PG_CRED_FORN_CREDITO_DEBITO AS 
SELECT
	CD_EMP,
	CD_FORN, 
	SUM(VLR_CRED) AS VLR_CRED, 
	SUM(VLR_DEB) AS VLR_DEB,
	DT_CAD
FROM
(SELECT     
	PG_CRED_FORN.CD_EMP,
	PG_CRED_FORN.CD_FORN, 
	PG_CRED_FORN.VLR_CRED AS VLR_CRED, 
	0 AS VLR_DEB,
	DT_CRED AS DT_CAD
FROM       
	PG_CRED_FORN  
UNION ALL
SELECT     
	PG_DEB_FORN.CD_EMP,
	PG_DEB_FORN.CD_FORN, 
	0 AS VLR_CRED, 
	VLR_DEB,
	DT_DEB AS DT_CAD 
FROM       
	PG_DEB_FORN) Rs
GROUP BY
	CD_EMP,
	CD_FORN, 
	DT_CAD